<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,700,900">

    <title>Pricing Quotation</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: auto;
            border: 1px solid #ddd;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        h1, h2 {
            text-align: center;
        }
        .client-info, .contact-info {
            margin-bottom: 20px;
        }
        .client-info input, .contact-info input {
            width: calc(100% - 20px);
            padding: 10px;
            margin: 5px 0;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid ;
        }
        th, td {
            padding: 10px;
            text-align: center;
        }
        tfoot {
            font-weight: bold;
        }
        .add-row {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 5px 10px;
            cursor: pointer;
            border-radius: 4px;
        }
        .add-row:hover {
            background-color: #45a049;
        }
        .generate-pdf {
            background-color: #2196F3;
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-radius: 4px;
            margin-top: 20px;
            display: block;
            width: 100%;
        }
        .generate-pdf:hover {
            background-color: #0b7dda;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>PRICING QUOTATION</h1>
        <div class="client-info">
            <h2>Client Information</h2>
            <label for="client-name">Name:</label>
            <input type="text" id="client-name" placeholder="Enter client name">
            <label for="client-address">Address:</label>
            <input type="text" id="client-address" placeholder="Enter client address">
            <label for="client-phone">Phone:</label>
            <input type="text" id="client-phone" placeholder="Enter client phone">
            <label for="client-email">Email:</label>
            <input type="text" id="client-email" placeholder="Enter client email">
        </div>
        
        <table id="quotation-table">
            <thead>
                <tr>
                    <th>REF</th>
                    <th>DESCRIPTION</th>
                    <th>QTY</th>
                    <th>UNIT PRICE</th>
                    <th>TOTAL</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td contenteditable="true">1</td>
                    <td contenteditable="true">Placare Verticala 2CM</td>
                    <td contenteditable="true">237.51</td>
                    <td contenteditable="true">64.95</td>
                    <td class="total">0.00</td>
                    <td><button class="add-row">+</button></td>
                </tr>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="5">SUBTOTAL</td>
                    <td id="subtotal">0.00</td>
                </tr>
                <tr>
                    <td colspan="5">TAX</td>
                    <td id="tax">N/A</td>
                </tr>
                <tr>
                    <td colspan="5">TOTAL</td>
                    <td id="total">0.00</td>
                </tr>
            </tfoot>
        </table>
        <button class="generate-pdf">Generate PDF</button>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.25/jspdf.plugin.autotable.min.js"></script>
   <script src="js/script-pdf.js"></script>
</body>
</html>
<?php /**PATH /Volumes/Personal/TeachMe/stone/stone/resources/views/offer-calculator.blade.php ENDPATH**/ ?>