<!-- resources/views/processings/index.blade.php -->



<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1 class="my-4">Processings</h1>
        <a href="<?php echo e(route('processing.create')); ?>" class="btn btn-primary mb-3">Add New Processing</a>
        <?php $__currentLoopData = $processings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $processing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card mb-3">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>
                        <strong><?php echo e($processing->name); ?></strong>
                        <?php if($processing->diameter_type === 'specific'): ?>
                            - Specific Diameter: <?php echo e($processing->specific_diameter); ?> -
                        <?php endif; ?>
                        Total Cost: <span class="text-danger">$<?php echo e(number_format($processing->total_cost, 2)); ?></span>
                    </span>
                    <div>
                        <a href="<?php echo e(route('processing.edit', $processing->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                        <form action="<?php echo e(route('processing.destroy', $processing->id)); ?>" method="POST" class="d-inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        <?php $__currentLoopData = $processing->costs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span class="cost-name"><?php echo e($cost->name); ?></span>
                                <span class="cost-price text-danger">€<?php echo e(number_format($cost->price, 2)); ?></span>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <style>
        .cost-name {
            color: black;
            font-weight: bold;
        }
        .cost-price {
            color: red;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/Personal/TeachMe/stone/stone/resources/views/processing/index.blade.php ENDPATH**/ ?>