<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('calculate')); ?>" method="POST" id="stoneForm">
        <?php echo csrf_field(); ?>
        <div id="stonePairs">
            <div class="stone-pair">
                <label for="name">Type of stone:</label>
                <select name="stones[]" class="stone-name">
                    <?php $__currentLoopData = $stonesType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($stone->name); ?>"><?php echo e($stone->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <label for="quantity">Quantity:</label>
                <input type="number" name="quantities[]" class="stone-quantity" min="1" required>
                <button type="button" class="remove-pair">Remove</button>
            </div>
        </div>
        <button type="button" id="addPair">Add Pair</button><br><br>

        <button type="submit">Calculate Total Quantity</button>
    </form>
    <?php if(isset($totalQuantity)): ?>
        <h1>Total quantity for <?php echo e($type); ?> is: <?php echo e($totalQuantity); ?></h1>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const addPairButton = document.getElementById('addPair');
            const stonePairs = document.getElementById('stonePairs');

            addPairButton.addEventListener('click', function () {
                const newPair = document.createElement('div');
                newPair.classList.add('stone-pair');
                newPair.innerHTML = `
                    <label for="name">Type of stone:</label>
                    <select name="stones[]" class="stone-name">
                        <?php $__currentLoopData = $stonesType; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($stone->name); ?>"><?php echo e($stone->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <label for="quantity">Quantity:</label>
                <input type="number" name="quantities[]" class="stone-quantity" min="1" required>
                <button type="button" class="remove-pair">Remove</button>
`;
                stonePairs.appendChild(newPair);
            });

            stonePairs.addEventListener('click', function (e) {
                if (e.target.classList.contains('remove-pair')) {
                    e.target.closest('.stone-pair').remove();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/Personal/TeachMe/stone/stone/resources/views/calculate.blade.php ENDPATH**/ ?>