<!-- resources/views/stone_types/index.blade.php -->


<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1 class="my-4">Stone Types</h1>
        <a href="<?php echo e(route('stone_types.create')); ?>" class="btn btn-primary mb-3">Add New Stone Type</a>
        <div class="row">
            <?php $__currentLoopData = $stoneTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stoneType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-5 mb-5">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title"><?php echo e($stoneType->name); ?></h5>
                        </div>
                        <div class="card-body">
                            <h6 class="card-subtitle mb-2 text-muted">Processings:</h6>
                            <ul class="list-group">
                                <?php $__currentLoopData = $stoneType->processings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $processing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item">
                                        <?php echo e($processing->name); ?> - Total Cost: $<?php echo e(number_format($processing->costs->sum('price'), 2)); ?>

                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <div class="card-footer">
                            <strong>Total Cost:</strong> $<?php echo e(number_format($stoneType->totalCost(), 2)); ?>

                            <div class="mt-3">
                                <a href="<?php echo e(route('stone_types.edit', $stoneType->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                                <form action="<?php echo e(route('stone_types.destroy', $stoneType->id)); ?>" method="POST" class="d-inline-block">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/Personal/TeachMe/stone/stone/resources/views/stone_types/index.blade.php ENDPATH**/ ?>