<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1 class="my-4">Stock Potatoes</h1>
        <a href="<?php echo e(route('stock_potatoes.create')); ?>" class="btn btn-primary mb-3">Add New Stock Potato</a>
        <table class="table">
            <thead>
            <tr>
                <th>Stone Type</th>
                <th>Dimensions</th>
                <th>Quantity</th>
                <th>QR Code</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $stockPotatoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stockPotato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($stockPotato->stoneType->name); ?></td>
                    <td><?php echo e($stockPotato->length); ?>x<?php echo e($stockPotato->width); ?>x<?php echo e($stockPotato->height); ?></td>
                    <td><?php echo e($stockPotato->quantity); ?></td>
                    <td><img src="<?php echo e(Storage::url($stockPotato->qr_code)); ?>" alt="QR Code" style="max-width: 100px;"></td>
                    <td>
                        <a href="<?php echo e(route('stock_potatoes.edit', $stockPotato->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                        <form action="<?php echo e(route('stock_potatoes.destroy', $stockPotato->id)); ?>" method="POST" class="d-inline-block">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                        </form>
                        <a href="<?php echo e(route('stock_potatoes.downloadQrCode', $stockPotato->id)); ?>" class="btn btn-sm btn-info">Download QR Code</a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/Personal/TeachMe/stone/stone/resources/views/stock_potatoes/index.blade.php ENDPATH**/ ?>