@extends('layouts.app')

@section('content')
    <div class="container">
        <h1 class="my-4">Add New Stone Type</h1>
        <form method="POST" action="{{ route('stone_types.store') }}">
            @csrf
            <div class="form-group">
                <label for="name">Stone Type Name</label>
                <input type="text" id="name" name="name" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="processings">Processings</label>
                <select multiple class="form-control" id="processings" name="processings[]">
                    @foreach($processings as $processing)
                        <option value="{{ $processing->id }}">{{ $processing->name }}</option>
                    @endforeach
                </select>
            </div>
            <button type="submit" class="btn btn-primary">Save Stone Type</button>
        </form>
    </div>
@endsection
