<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Code Scanner</title>
</head>
<body>
<div id="scanner-container"></div>
<div id="result"></div>

<script src="https://cdn.jsdelivr.net/npm/jsqr/dist/jsQR.min.js"></script>
<script>
    navigator.mediaDevices.getUserMedia({ video: { facingMode: "environment" } })
        .then(function(stream) {
            var video = document.createElement("video");
            video.setAttribute("autoplay", true);
            video.srcObject = stream;
            document.getElementById("scanner-container").appendChild(video);

            video.onloadedmetadata = function(e) {
                var canvas = document.createElement("canvas");
                var context = canvas.getContext("2d");
                canvas.width = video.videoWidth;
                canvas.height = video.videoHeight;

                setInterval(function() {
                    context.drawImage(video, 0, 0, canvas.width, canvas.height);
                    var imageData = context.getImageData(0, 0, canvas.width, canvas.height);
                    var code = jsQR(imageData.data, imageData.width, imageData.height);
                    if (code) {
                        console.log("QR Code detected:", code.data);
                        document.getElementById("result").innerText = "QR Code detected: " + code.data;
                    }
                }, 1000);
            };
        })
        .catch(function(error) {
            console.error("Error accessing the camera:", error);
            document.getElementById("result").innerText = "Error accessing the camera: " + error.message;
        });
</script>
</body>
</html>
