@extends('layouts.app')

@section('content')
    <div class="container">
        <h1 class="my-4">Stock Potatoes</h1>
        <a href="{{ route('stock_potatoes.create') }}" class="btn btn-primary mb-3">Add New Stock Potato</a>
        <table class="table">
            <thead>
            <tr>
                <th>Stone Type</th>
                <th>Dimensions</th>
                <th>Quantity</th>
                <th>QR Code</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            @foreach($stockPotatoes as $stockPotato)
                <tr>
                    <td>{{ $stockPotato->stoneType->name }}</td>
                    <td>{{ $stockPotato->length }}x{{ $stockPotato->width }}x{{ $stockPotato->height }}</td>
                    <td>{{ $stockPotato->quantity }}</td>
                    <td><img src="{{ Storage::url($stockPotato->qr_code) }}" alt="QR Code" style="max-width: 100px;"></td>
                    <td>
                        <a href="{{ route('stock_potatoes.edit', $stockPotato->id) }}" class="btn btn-sm btn-warning">Edit</a>
                        <form action="{{ route('stock_potatoes.destroy', $stockPotato->id) }}" method="POST" class="d-inline-block">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                        </form>
                        <a href="{{ route('stock_potatoes.downloadQrCode', $stockPotato->id) }}" class="btn btn-sm btn-info">Download QR Code</a>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@endsection
