@extends('layouts.app')

@section('content')
    <div class="container">
        <h1 class="my-4">Add New Stock Potato</h1>
        <form method="POST" action="{{ route('stock_potatoes.store') }}">
            @csrf
            <div class="form-group">
                <label for="stone_type_id">Stone Type</label>
                <select id="stone_type_id" name="stone_type_id" class="form-control" required>
                    @foreach($stoneTypes as $stoneType)
                        <option value="{{ $stoneType->id }}">{{ $stoneType->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label for="length">Length</label>
                <input type="number" id="length" name="length" class="form-control" step="0.01" required>
            </div>
            <div class="form-group">
                <label for="width">Width</label>
                <input type="number" id="width" name="width" class="form-control" step="0.01" required>
            </div>
            <div class="form-group">
                <label for="height">Height</label>
                <input type="number" id="height" name="height" class="form-control" step="0.01" required>
            </div>
            <div class="form-group">
                <label for="quantity">Quantity</label>
                <input type="number" id="quantity" name="quantity" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary">Save Stock Potato</button>
        </form>
    </div>
@endsection
