<!-- resources/views/processings/index.blade.php -->

@extends('layouts.app')

@section('content')
    <div class="container">
        <h1 class="my-4">Processings</h1>
        <a href="{{ route('processing.create') }}" class="btn btn-primary mb-3">Add New Processing</a>
        @foreach($processings as $processing)
            <div class="card mb-3">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>
                        <strong>{{ $processing->name }}</strong>
                        @if($processing->diameter_type === 'specific')
                            - Specific Diameter: {{ $processing->specific_diameter }} -
                        @endif
                        Total Cost: <span class="text-danger">${{ number_format($processing->total_cost, 2) }}</span>
                    </span>
                    <div>
                        <a href="{{ route('processing.edit', $processing->id) }}" class="btn btn-sm btn-warning">Edit</a>
                        <form action="{{ route('processing.destroy', $processing->id) }}" method="POST" class="d-inline-block">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    <ul class="list-group">
                        @foreach($processing->costs as $cost)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span class="cost-name">{{ $cost->name }}</span>
                                <span class="cost-price text-danger">€{{ number_format($cost->price, 2) }}</span>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        @endforeach
    </div>

    <style>
        .cost-name {
            color: black;
            font-weight: bold;
        }
        .cost-price {
            color: red;
        }
    </style>
@endsection
