{{--@extends('layouts.app')--}}

{{--@section('content')--}}
{{--    <form action="{{ route('calculate') }}" method="POST">--}}
{{--        @csrf--}}
{{--        <label for="name">Type of stone:</label>--}}
{{--        <select name="name" id="name">--}}
{{--            @foreach($stonesType as $stone)--}}
{{--                <option value="{{ $stone->name }}">{{ $stone->name }}</option>--}}
{{--            @endforeach--}}
{{--        </select><br><br>--}}

{{--        <label for="quantity">Quantity:</label>--}}
{{--        <input type="number" name="quantity" id="quantity" min="1" required><br><br>--}}

{{--        <button type="submit">Result</button>--}}
{{--    </form>--}}
{{--    @if(isset($totalQuantity))--}}
{{--        <h1>Totalul cantităților pentru {{ $type }} este: {{ $totalQuantity }}</h1>--}}
{{--    @endif--}}

{{--@endsection--}}


@extends('layouts.app')

@section('content')
    <form action="{{ route('calculate') }}" method="POST" id="stoneForm">
        @csrf
        <div id="stonePairs">
            <div class="stone-pair">
                <label for="name">Type of stone:</label>
                <select name="stones[]" class="stone-name">
                    @foreach($stonesType as $stone)
                        <option value="{{ $stone->name }}">{{ $stone->name }}</option>
                    @endforeach
                </select>
                <label for="quantity">Quantity:</label>
                <input type="number" name="quantities[]" class="stone-quantity" min="1" required>
                <button type="button" class="remove-pair">Remove</button>
            </div>
        </div>
        <button type="button" id="addPair">Add Pair</button><br><br>

        <button type="submit">Calculate Total Quantity</button>
    </form>
    @if(isset($totalQuantity))
        <h1>Total quantity for {{ $type }} is: {{ $totalQuantity }}</h1>
    @endif
@endsection

@section('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const addPairButton = document.getElementById('addPair');
            const stonePairs = document.getElementById('stonePairs');

            addPairButton.addEventListener('click', function () {
                const newPair = document.createElement('div');
                newPair.classList.add('stone-pair');
                newPair.innerHTML = `
                    <label for="name">Type of stone:</label>
                    <select name="stones[]" class="stone-name">
                        @foreach($stonesType as $stone)
                <option value="{{ $stone->name }}">{{ $stone->name }}</option>
                        @endforeach
                </select>
                <label for="quantity">Quantity:</label>
                <input type="number" name="quantities[]" class="stone-quantity" min="1" required>
                <button type="button" class="remove-pair">Remove</button>
`;
                stonePairs.appendChild(newPair);
            });

            stonePairs.addEventListener('click', function (e) {
                if (e.target.classList.contains('remove-pair')) {
                    e.target.closest('.stone-pair').remove();
                }
            });
        });
    </script>
@endsection
