document.addEventListener('input', function() {
    let subtotal = 0;
    document.querySelectorAll('#quotation-table tbody tr').forEach(row => {
        const qty = parseFloat(row.cells[2].innerText) || 0;
        const unitPrice = parseFloat(row.cells[3].innerText) || 0;
        const total = qty * unitPrice;
        row.cells[4].innerText = total.toFixed(2);
        subtotal += total;
    });
    document.getElementById('subtotal').innerText = subtotal.toFixed(2);
    document.getElementById('total').innerText = subtotal.toFixed(2);
});

document.querySelectorAll('.add-row').forEach(button => {
    button.addEventListener('click', function() {
        const row = document.createElement('tr');
        row.innerHTML = `
            <td contenteditable="true"></td>
            <td contenteditable="true"></td>
            <td contenteditable="true"></td>
            <td contenteditable="true"></td>
            <td class="total">0.00</td>
            <td><button class="add-row">+</button></td>
        `;
        this.closest('tbody').appendChild(row);
        row.querySelector('.add-row').addEventListener('click', function() {
            const newRow = document.createElement('tr');
            newRow.innerHTML = `
                <td contenteditable="true"></td>
                <td contenteditable="true"></td>
                <td contenteditable="true"></td>
                <td contenteditable="true"></td>
                <td class="total">0.00</td>
                <td><button class="add-row">+</button></td>
            `;
            this.closest('tbody').appendChild(newRow);
            newRow.querySelector('.add-row').addEventListener('click', arguments.callee);
        });
    });
});

document.querySelector('.generate-pdf').addEventListener('click', function() {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF();
// Inițializează imagini
const imgLogo1 = new Image();
const imgLogo2 = new Image();
imgLogo1.src = 'img/sun-min.png'; // Calea relativă către primul logo
imgLogo2.src = 'img/sun-min.png'; // Calea relativă către al doilea logo

imgLogo1.onload = function() {
imgLogo2.onload = function() {
// Adaugă prima imagine
const logo1Width = 262.28;
const logo1Height = 381.5;
const logo1X = 435;
const logo1Angle = 75; // în grade

doc.addImage(imgLogo1, 'PNG', logo1X, -175, logo1Width, logo1Height, undefined, undefined, logo1Angle);
 
 doc.setFontSize(28);
 doc.setTextColor(0, 0, 0); 
 doc.text('PRICING QUOTATION', 14, 50, { align: 'left' }); // Adjust alignment as needed

doc.setFontSize(12);
doc.text('Client Information:', 14, 60);
doc.text(`Name: ${document.getElementById('client-name').value}`, 14, 65);
doc.text(`Address: ${document.getElementById('client-address').value}`, 14, 70);
doc.text(`Phone: ${document.getElementById('client-phone').value}`, 14, 75);
doc.text(`Email: ${document.getElementById('client-email').value}`, 14, 80);

doc.autoTable({ 
    startY: 90,
    html: '#quotation-table',
    styles: { 
        cellPadding: 2, 
        fontSize: 8,
        halign: 'center',
        valign: 'middle'
    },
    headStyles: {
        fillColor: [255, 255, 255], 
        textColor: [0, 0, 0]
    },
    footStyles: {
        fillColor: [255, 255, 255], 
        textColor: [0, 0, 0] 
    },
    didParseCell: function (data) {
        if (data.row.index >= data.table.body.length - 3) { // Ultimele 3 rânduri (de obicei subtotal, taxă, total)
            data.cell.styles.halign = 'right'; // Aliniere la dreapta
        }
    },
    columnStyles: {
        0: { cellWidth: 20 },
        1: { cellWidth: 50 },
        2: { cellWidth: 30 },
        3: { cellWidth: 30 },
        4: { cellWidth: 30 }
    }
    
});

const pageWidth = doc.internal.pageSize.width;
const pageHeight = doc.internal.pageSize.height;

const imgWidth = 70;
const imgHeight = 60;

const logoX = -0;
const logoY = pageHeight - imgHeight;
doc.addImage(imgLogo2, 'PNG', logoX, logoY, imgWidth, imgHeight);

// Poziționează textul "THANK YOU FOR YOUR BUSINESS" în dreapta jos
const textX = 120; // Distanta de la marginea stângă la text
const textY = pageHeight - 10;
doc.setFontSize(15);

doc.text('THANK YOU FOR YOUR BUSINESS', textX+10, textY-30, { align: 'center' });

const contactX = 70; 
const columnWidth = 80; 
const startY = textY ; 


doc.setFontSize(10);
doc.text('CONTACT', contactX, startY - 17);
doc.text('Alexandru COCINDAU', contactX, startY - 9);

const secondColumnX = contactX + columnWidth; 
doc.setFont('Poppins', 'normal'); 
doc.text('PHONE:', secondColumnX-10, startY -17);
doc.text('EMAIL:', secondColumnX-10, startY -9);
doc.text('WEB:', secondColumnX-10, startY -2);

doc.text('+34 617 187 223', secondColumnX + 10, startY-17);
doc.text('uae@sunminerals.rocks', secondColumnX+10, startY -9);
doc.text('www.sunminerals.rocks', secondColumnX+10, startY -2);

doc.save('quotation.pdf');
};
};

});