<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('stone_type_processing', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('stone_type_id');
            $table->unsignedBigInteger('processing_id');
            $table->timestamps();

            $table->foreign('stone_type_id')->references('id')->on('stone_types')->onDelete('cascade');
            $table->foreign('processing_id')->references('id')->on('processings')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('stone_type_processing');
    }

};
