<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('processings', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('diameter_type', ['any', 'specific'])->default('any');
            $table->decimal('specific_diameter', 10, 2)->nullable();
            $table->decimal('total_cost', 8, 2)->default(0);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('processings');
    }

};
