<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\StoneType;
use Barryvdh\DomPDF\Facade\Pdf;
class StoneCalculatorController extends Controller
{
    public function index()
    {
        $stonesType = StoneType::all();
        return view('calculate', compact('stonesType'));
    }

    public function offer()
    {
        $stonesType = StoneType::all();
        return view('offer-calculator');
    }
//
//    public function calculate(Request $request)
//    {
//        // Validează datele din request
//        $request->validate([
//            'name' => 'required|string',
//            'quantity' => 'required|integer|min:1',
//        ]);
//        $stonesType = StoneType::all();
//
//        $stoneType = StoneType::where('name', $request->name)->first();
//        $stoneTypeCosts = StoneType::with('processings.costs')->findOrFail( $stoneType->id);
//        $stoneTypeCost = $stoneTypeCosts->totalCost();
//
//        $total = $request->quantity * $stoneTypeCost;
//return view('calculate', [
//            'stonesType' => $stonesType,
//            'type' => $request->type,
//            'quantity' => $request->quantity,
//            'totalQuantity' => $total,
//        ]);
//    }
//}

    public function generatePDF()
    {
        $data = [
            'toName' => 'Mohamed Khalifa',
            'address' => 'Musaffah - Musaffah Industrial - Abu Dhabi - United Arab Emirates',
            'phone' => '+971 2 555 5505',
            'email' => '',
            'date' => '31/07/2024',
            'items' => [
                ['ref' => '1', 'description' => '2CM Cutter Slab - Sivec Marble', 'qty' => '3,400 mp', 'unit_price' => '$ 64.95', 'total' => '$ 220,830.00'],
                ['ref' => '2', 'description' => '3CM Cutter Slab - Sivec Marble', 'qty' => '6,200 mp', 'unit_price' => '$ 81.19', 'total' => '$ 503,378.00']
            ],
            'subtotal' => '$724,208.00',
            'tax' => 'N/A',
            'total' => '$724,208.00',
            'contactName' => 'Alexandru COCINDAU',
            'contactPhone' => '+34 617 187 223',
            'contactEmail' => 'uae@sunminerals.rocks',
            'contactWeb' => 'www.sunminerals.rocks'
        ];

        $pdf = PDF::loadView('offer', $data);
        return $pdf->download('quotation.pdf');
    }

    public function calculate(Request $request)
    {
        // Validează datele din request
        $request->validate([
            'stones.*' => 'required|string',
            'quantities.*' => 'required|integer|min:1',
        ]);

        $totalQuantities = [];

        // Iterăm prin fiecare ereche de tip de piatră și cantitate
        foreach ($request->stones as $index => $stone) {
            // Găsim tipul de piatr după nume
            $stoneType = StoneType::where('name', $stone)->first();

            // Verificăm dacă am găsit tipul de piatră
            if ($stoneType) {
                // Calculăm cantitatea totală pentru această pereche
                $totalQuantity = $request->quantities[$index] * $stoneType->totalCost(); // Aici poți calcula în funcție de logică specifică

                // Adăugăm în array-ul de rezultate
                $totalQuantities[$stoneType->name] = $totalQuantity;
            }
        }

        // Returnăm view-ul cu rezultatele calculate
        return view('calculate', [
            'stonesType' => StoneType::all(), // Încărcăm din nou toate tipurile de piatră pentru a le afișa în formular
            'totalQuantities' => $totalQuantities,
        ]);
    }
}
