<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1 class="my-4">Edit Processing</h1>
        <form method="POST" action="<?php echo e(route('processing.update', $processing->id)); ?>">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="form-group">
                <label for="name">Processing Name</label>
                <input type="text" id="name" name="name" class="form-control" value="<?php echo e($processing->name); ?>" required>
            </div>
            <div class="form-group">
                <label for="diameter">Diameter</label><br>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="diameter_type" id="any_diameter" value="any" <?php echo e($processing->diameter_type === 'any' ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="any_diameter">Any Diameter</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="diameter_type" id="specific_diameter" value="specific" <?php echo e($processing->diameter_type === 'specific' ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="specific_diameter">Specific Diameter</label>
                </div>
                <input type="number" step="0.01" name="specific_diameter" class="form-control <?php echo e($processing->diameter_type === 'specific' ? '' : 'd-none'); ?>" id="specific_diameter_input" placeholder="Enter Specific Diameter" value="<?php echo e($processing->specific_diameter); ?>">
            </div>
            <div id="costs">
                <h3>Costs</h3>
                <?php $__currentLoopData = $processing->costs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="cost form-row align-items-center mb-2">
                        <div class="col">
                            <input type="text" name="costs[<?php echo e($index); ?>][name]" class="form-control" placeholder="Cost Name" value="<?php echo e($cost->name); ?>" required>
                        </div>
                        <div class="col">
                            <input type="number" step="0.01" name="costs[<?php echo e($index); ?>][price]" class="form-control" placeholder="Price" value="<?php echo e($cost->price); ?>" required>
                        </div>
                        <div class="col-auto">
                            <button type="button" class="btn btn-danger btn-remove-cost">&times;</button>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <button type="button" id="add-cost" class="btn btn-success mb-3">Add Another Cost</button>
            <div class="d-flex">
                <button type="submit" class="btn btn-primary ml-auto">Update Processing</button>
            </div>
        </form>
    </div>

    <script>
        function toggleSpecificDiameterInput() {
            const specificDiameterInput = document.getElementById('specific_diameter_input');
            const specificDiameterRadio = document.getElementById('specific_diameter');
            specificDiameterInput.classList.toggle('d-none', !specificDiameterRadio.checked);
        }

        window.addEventListener('load', toggleSpecificDiameterInput);

        document.getElementById('any_diameter').addEventListener('change', toggleSpecificDiameterInput);
        document.getElementById('specific_diameter').addEventListener('change', toggleSpecificDiameterInput);

        document.getElementById('add-cost').addEventListener('click', function () {
            const costsDiv = document.getElementById('costs');
            const index = costsDiv.getElementsByClassName('cost').length;
            const newCostDiv = document.createElement('div');
            newCostDiv.className = 'cost form-row align-items-center mb-2';
            newCostDiv.innerHTML = `
                <div class="col">
                    <input type="text" name="costs[${index}][name]" class="form-control" placeholder="Cost Name" required>
                </div>
                <div class="col">
                    <input type="number" step="0.01" name="costs[${index}][price]" class="form-control" placeholder="Price" required>
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-danger btn-remove-cost">&times;</button>
                </div>
            `;
            costsDiv.appendChild(newCostDiv);

            newCostDiv.querySelector('.btn-remove-cost').addEventListener('click', function () {
                newCostDiv.remove();
            });
        });

        document.querySelectorAll('.btn-remove-cost').forEach(function(button) {
            button.addEventListener('click', function () {
                button.closest('.cost').remove();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/Personal/TeachMe/stone/stone/resources/views/processing/edit.blade.php ENDPATH**/ ?>