<?php $__env->startSection('content'); ?>
    <div class="container mt-5">
        <h1 class="mb-4">Stones List</h1>
        <?php if($message = Session::get('success')): ?>
            <div class="alert alert-success">
                <p><?php echo e($message); ?></p>
            </div>
        <?php endif; ?>
        <a href="<?php echo e(route('stones.create')); ?>" class="btn btn-primary mb-3">Add Stone</a>
        <table class="table table-bordered table-striped">
            <thead>
            <tr>
                <th>ID</th>
                <th>Length</th>
                <th>Width</th>
                <th>Diameter</th>
                <th>Stone Type</th>
                <th>Price</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $stones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($stone->id); ?></td>
                    <td><?php echo e($stone->length); ?></td>
                    <td><?php echo e($stone->width); ?></td>
                    <td><?php echo e($stone->diameter); ?></td>
                    <td><?php echo e($stone->stoneType->name); ?></td>
                    <td><?php echo e($stone->price); ?></td>
                    <td>
                        <a href="<?php echo e(route('stones.edit', $stone->id)); ?>" class="btn btn-warning btn-sm">Edit</a>
                        <form action="<?php echo e(route('stones.destroy', $stone->id)); ?>" method="POST" style="display:inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/Personal/TeachMe/stone/stone/resources/views/stones/index.blade.php ENDPATH**/ ?>