<!-- resources/views/stone_types/index.blade.php -->
@extends('layouts.app')

@section('content')
    <div class="container">
        <h1 class="my-4">Stone Types</h1>
        <a href="{{ route('stone_types.create') }}" class="btn btn-primary mb-3">Add New Stone Type</a>
        <div class="row">
            @foreach($stoneTypes as $stoneType)
                <div class="col-md-5 mb-5">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title">{{ $stoneType->name }}</h5>
                        </div>
                        <div class="card-body">
                            <h6 class="card-subtitle mb-2 text-muted">Processings:</h6>
                            <ul class="list-group">
                                @foreach($stoneType->processings as $processing)
                                    <li class="list-group-item">
                                        {{ $processing->name }} - Total Cost: ${{ number_format($processing->costs->sum('price'), 2) }}
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="card-footer">
                            <strong>Total Cost:</strong> ${{ number_format($stoneType->totalCost(), 2) }}
                            <div class="mt-3">
                                <a href="{{ route('stone_types.edit', $stoneType->id) }}" class="btn btn-sm btn-warning">Edit</a>
                                <form action="{{ route('stone_types.destroy', $stoneType->id) }}" method="POST" class="d-inline-block">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@endsection
