@extends('layouts.app')

@section('content')
    <div class="container">
        <h1 class="my-4">Edit Processing</h1>
        <form method="POST" action="{{ route('processing.update', $processing->id) }}">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label for="name">Processing Name</label>
                <input type="text" id="name" name="name" class="form-control" value="{{ $processing->name }}" required>
            </div>
            <div class="form-group">
                <label for="diameter">Diameter</label><br>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="diameter_type" id="any_diameter" value="any" {{ $processing->diameter_type === 'any' ? 'checked' : '' }}>
                    <label class="form-check-label" for="any_diameter">Any Diameter</label>
                </div>
                <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="diameter_type" id="specific_diameter" value="specific" {{ $processing->diameter_type === 'specific' ? 'checked' : '' }}>
                    <label class="form-check-label" for="specific_diameter">Specific Diameter</label>
                </div>
                <input type="number" step="0.01" name="specific_diameter" class="form-control {{ $processing->diameter_type === 'specific' ? '' : 'd-none' }}" id="specific_diameter_input" placeholder="Enter Specific Diameter" value="{{ $processing->specific_diameter }}">
            </div>
            <div id="costs">
                <h3>Costs</h3>
                @foreach($processing->costs as $index => $cost)
                    <div class="cost form-row align-items-center mb-2">
                        <div class="col">
                            <input type="text" name="costs[{{ $index }}][name]" class="form-control" placeholder="Cost Name" value="{{ $cost->name }}" required>
                        </div>
                        <div class="col">
                            <input type="number" step="0.01" name="costs[{{ $index }}][price]" class="form-control" placeholder="Price" value="{{ $cost->price }}" required>
                        </div>
                        <div class="col-auto">
                            <button type="button" class="btn btn-danger btn-remove-cost">&times;</button>
                        </div>
                    </div>
                @endforeach
            </div>
            <button type="button" id="add-cost" class="btn btn-success mb-3">Add Another Cost</button>
            <div class="d-flex">
                <button type="submit" class="btn btn-primary ml-auto">Update Processing</button>
            </div>
        </form>
    </div>

    <script>
        function toggleSpecificDiameterInput() {
            const specificDiameterInput = document.getElementById('specific_diameter_input');
            const specificDiameterRadio = document.getElementById('specific_diameter');
            specificDiameterInput.classList.toggle('d-none', !specificDiameterRadio.checked);
        }

        window.addEventListener('load', toggleSpecificDiameterInput);

        document.getElementById('any_diameter').addEventListener('change', toggleSpecificDiameterInput);
        document.getElementById('specific_diameter').addEventListener('change', toggleSpecificDiameterInput);

        document.getElementById('add-cost').addEventListener('click', function () {
            const costsDiv = document.getElementById('costs');
            const index = costsDiv.getElementsByClassName('cost').length;
            const newCostDiv = document.createElement('div');
            newCostDiv.className = 'cost form-row align-items-center mb-2';
            newCostDiv.innerHTML = `
                <div class="col">
                    <input type="text" name="costs[${index}][name]" class="form-control" placeholder="Cost Name" required>
                </div>
                <div class="col">
                    <input type="number" step="0.01" name="costs[${index}][price]" class="form-control" placeholder="Price" required>
                </div>
                <div class="col-auto">
                    <button type="button" class="btn btn-danger btn-remove-cost">&times;</button>
                </div>
            `;
            costsDiv.appendChild(newCostDiv);

            newCostDiv.querySelector('.btn-remove-cost').addEventListener('click', function () {
                newCostDiv.remove();
            });
        });

        document.querySelectorAll('.btn-remove-cost').forEach(function(button) {
            button.addEventListener('click', function () {
                button.closest('.cost').remove();
            });
        });
    </script>
@endsection
