<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\StoneType;
use App\Models\Processing;

class StoneTypeController extends Controller
{
    public function index()
    {
        $stoneTypes = StoneType::with('processings.costs')->get();
        return view('stone_types.index', compact('stoneTypes'));
    }

    public function create()
    {
        $processings = Processing::all();
        return view('stone_types.add', compact('processings'));
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            'processings' => 'array',
        ]);

        $stoneType = StoneType::create([
            'name' => $validatedData['name'],
        ]);

        if(isset($validatedData['processings'])) {
            $stoneType->processings()->attach($validatedData['processings']);
        }

        return redirect()->route('stone_types.index')->with('success', 'Stone type created successfully.');
    }

    public function edit(StoneType $stoneType)
    {
        $processings = Processing::all();
        return view('stone_types.edit', compact('stoneType', 'processings'));
    }

    public function update(Request $request, StoneType $stoneType)
    {
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            'processings' => 'array',
        ]);

        $stoneType->update([
            'name' => $validatedData['name'],
        ]);

        $stoneType->processings()->sync($validatedData['processings'] ?? []);

        return redirect()->route('stone_types.index')->with('success', 'Stone type updated successfully.');
    }

    public function destroy(StoneType $stoneType)
    {
        $stoneType->delete();
        return redirect()->route('stone_types.index')->with('success', 'Stone type deleted successfully.');
    }
}
