<?php $__env->startSection('content'); ?>
    <div class="edit-container">
        <form id="scan-form" action="<?php echo e(route('qr_scan.scan')); ?>" method="post" class="edit-form">
            <?php echo csrf_field(); ?>
            <div class="column">
                <label for="qr_code">Scan QR Code:</label>
                <div id="scanner-container"></div>
                <div id="result"></div>
            </div>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/quagga/dist/quagga.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        Quagga.init({
            inputStream: {
                name: "Live",
                type: "LiveStream",
                target: document.querySelector('#scanner-container')
            },
            decoder: {
                readers: ["qrcode_reader"]
            }
        }, function(err) {
            if (err) {
                console.error(err);
                return;
            }
            Quagga.start();
            Quagga.onDetected(function(result) {
                var code = result.codeResult.code;
                document.querySelector('#qr_code').value = code;
                Quagga.stop();
            });
        });

        $('#scan-form').submit(function(e) {
            e.preventDefault();
            var qrCode = $('#qr_code').val();
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('qr_scan.scan')); ?>",
                data: { _token: "<?php echo e(csrf_token()); ?>", qr_code: qrCode },
                success: function(response) {
                    $('#result').html(response.message);
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Volumes/Personal/TeachMe/stone/stone/resources/views/stock_potatoes/scan.blade.php ENDPATH**/ ?>