<?php
use App\Http\Controllers\ProcessingController;
use App\Http\Controllers\QrCodeController;
use App\Http\Controllers\StockPotatoController;
use App\Http\Controllers\StoneTypeController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('layouts.app');
});

Route::get('stone_types', [StoneTypeController::class, 'index'])->name('stone_types.index');
Route::get('stone_types/create', [StoneTypeController::class, 'create'])->name('stone_types.create');
Route::post('stone_types', [StoneTypeController::class, 'store'])->name('stone_types.store');
Route::get('stone_types/{stone_type}/edit', [StoneTypeController::class, 'edit'])->name('stone_types.edit');
Route::put('stone_types/{stone_type}', [StoneTypeController::class, 'update'])->name('stone_types.update');
Route::delete('stone_types/{stone_type}', [StoneTypeController::class, 'destroy'])->name('stone_types.destroy');

Route::get('/processing', [ProcessingController::class, 'index'])->name('processing.index');
Route::get('/processing/create', [ProcessingController::class, 'create'])->name('processing.create');
Route::post('/processing', [ProcessingController::class, 'store'])->name('processing.store');

Route::get('/processing/{processing}/edit', [ProcessingController::class, 'edit'])->name('processing.edit');
Route::put('/processing/{processing}', [ProcessingController::class, 'update'])->name('processing.update');
Route::delete('/processing/{processing}', [ProcessingController::class, 'destroy'])->name('processing.destroy');

Route::get('stock_potatoes', [StockPotatoController::class, 'index'])->name('stock_potatoes.index');
Route::get('stock_potatoes/create', [StockPotatoController::class, 'create'])->name('stock_potatoes.create');
Route::post('stock_potatoes', [StockPotatoController::class, 'store'])->name('stock_potatoes.store');
Route::get('stock_potatoes/{stock_potato}/edit', [StockPotatoController::class, 'edit'])->name('stock_potatoes.edit');
Route::put('stock_potatoes/{stock_potato}', [StockPotatoController::class, 'update'])->name('stock_potatoes.update');
Route::delete('stock_potatoes/{stock_potato}', [StockPotatoController::class, 'destroy'])->name('stock_potatoes.destroy');
Route::get('stock_potatoes/{stockPotato}/download-qr', [StockPotatoController::class, 'downloadQrCode'])->name('stock_potatoes.downloadQrCode');

Route::post('qr-scan', [QrCodeController::class, 'scan'])->name('qr_scan.scan');
Route::get('potatoes/scan', [QrCodeController::class, 'index'])->name('qr_scan.index');
