<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStockPotatoesTable extends Migration
{
    public function up()
    {
        Schema::create('stock_potatoes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('stone_type_id')->constrained()->onDelete('cascade');
            $table->decimal('length', 8, 2);
            $table->decimal('width', 8, 2);
            $table->decimal('height', 8, 2);
            $table->string('qr_code')->nullable();
            $table->integer('quantity');
            $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('stock_potatoes');
    }
}
