<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    // database/migrations/xxxx_xx_xx_create_costs_table.php

    public function up()
    {
        Schema::create('costs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('processing_id');
            $table->string('name');
            $table->decimal('price', 8, 2);
            $table->timestamps();

            $table->foreign('processing_id')->references('id')->on('processings')->onDelete('cascade');
        });
    }

    public function down()
    {
        Schema::dropIfExists('costs');
    }

};
