<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StoneType extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
    ];

    public function processings()
    {
        return $this->belongsToMany('App\Models\Processing', 'stone_type_processing');
    }

    public function stockPotatoes()
    {
        return $this->hasMany(StockPotato::class);
    }

    public function totalCost()
    {
        $totalCost = 0;

        foreach ($this->processings as $processing) {
            $totalCost += $processing->costs()->sum('price');
        }

        return $totalCost;
    }
}
